// Copyright 2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /var/mnt/Data/CVS_REPO/Clients/Marketcircle/Frameworks/MCApplication/OAAppleScript.h,v 1.11 2007/12/06 19:57:26 alalani Exp $

#import <Foundation/NSObject.h>
//#import <Carbon/Carbon.h>

@class NSString, NSData, NSArray;
@class NSMutableArray;

@interface OAAppleScript : NSObject
{
//    OSAID              _scriptId;
}

//- initWithContentsOfFile:(NSString *)filename;
//- initWithScriptData:(NSData *)scriptData;
//- initWithScriptString: (NSString *) scriptString;
//- (NSString *) execute;
+ (NSString *)stringByEscapingForApplescript:(NSString *)theString;

// Utility methods build on OAAppleScript
+ (NSString *) executeScriptString: (NSString *) scriptString;

+ (void) sendMailTo:(NSString *) receiver
         carbonCopy:(NSString *) carbonCopy
            subject:(NSString *) subject
               body:(NSString *) body;

+ (void) sendMailTo:(NSString *) receiver
         carbonCopy:(NSString *) carbonCopy
		  blindCopy:(NSString *) blindCopy
            subject:(NSString *) subject
               body:(NSString *) body;

+ (void) sendMailTo:(NSString *) receiver
         carbonCopy:(NSString *) carbonCopy
				   blindCopy:(NSString *) blindCopy
            subject:(NSString *) subject
               body:(NSString *) body
						  autoSend:(BOOL)autoSend;

+ (void) sendMailTo:(NSString *) receiver
         carbonCopy:(NSString *) carbonCopy
          blindCopy:(NSString *) blindCopy
            subject:(NSString *) subject
               body:(NSString *) body
           autoSend:(BOOL)autoSend
    attachmentPaths:(NSArray *)attachmentPaths;

+ (void) sendMailTo:(NSString *) receiver
         carbonCopy:(NSString *) carbonCopy
          blindCopy:(NSString *) blindCopy
            subject:(NSString *) subject
               body:(NSString *) body
           autoSend:(BOOL)autoSend
    attachmentPaths:(NSArray *)attachmentPaths
   threadIfPossible:(BOOL)shouldThread;


+ (NSString *)formScriptForClientEntourage:(NSString *)receiver
								carbonCopy:(NSString *)carbonCopy
								 blindCopy:(NSString *)blindCopy
			                       subject:(NSString *)subject
			                          body:(NSString *)body
			                      autoSend:(BOOL)autoSend
						   attachmentPaths:(NSArray *)attachmentPaths;

+ (NSString *)formScriptForClientMailApp:(NSString *)receiver
							  carbonCopy:(NSString *)carbonCopy
							   blindCopy:(NSString *)blindCopy
							     subject:(NSString *)subject
									body:(NSString *)body
								autoSend:(BOOL)autoSend
						 attachmentPaths:(NSArray *)attachmentPaths;

+ (NSString *)formScriptForClientPowerMail:(NSString *)receiver
								carbonCopy:(NSString *)carbonCopy
								 blindCopy:(NSString *)blindCopy
								   subject:(NSString *)subject
									  body:(NSString *)body
								   autoSend:(BOOL)autoSend
							attachmentPaths:(NSArray *)attachmentPaths;

+ (NSString *)formScriptForClientMailsmith:(NSString *)receiver
								carbonCopy:(NSString *)carbonCopy
								 blindCopy:(NSString *)blindCopy
								   subject:(NSString *)subject
									  body:(NSString *)body
								  autoSend:(BOOL)autoSend
						   attachmentPaths:(NSArray *)attachmentPaths;

+ (NSString *)formScriptForClientMailPlaneApp:(NSString *)receiver
								   carbonCopy:(NSString *)carbonCopy
									blindCopy:(NSString *)blindCopy
									  subject:(NSString *)subject
										 body:(NSString *)body
									 autoSend:(BOOL)autoSend
							  attachmentPaths:(NSArray *)attachmentPaths;

@end
